(function () {
  let ws;
  const btnLogin = document.querySelector(".btn-login");
  const roomUI = document.querySelector(".room-ui");
  const roomNameEl = document.querySelector(".room-name");
  const btnExit = document.querySelector(".btn-exit");
  const dialog = document.getElementById("staff-dialog");
  const acceptBtn = document.getElementById("accept-btn");
  const requestListEl = document.getElementById("request-list");
  let clientId = "";
  const loginForm = document.querySelector(".login-form");
  let key_clb = "";
  let timeRequest = null;
  let currentTab = "pending";
  let vibrationInterval;

  function formatDateTime(date = new Date()) {
    const dd = String(date.getDate()).padStart(2, "0");
    const MM = String(date.getMonth() + 1); // tháng bắt đầu từ 0
    const yyyy = date.getFullYear();

    const hh = String(date.getHours()).padStart(2, "0");
    const mm = String(date.getMinutes()).padStart(2, "0");
    const ss = String(date.getSeconds()).padStart(2, "0");

    return `${dd}/${MM}/${yyyy} ${hh}:${mm}:${ss}`;
  }

  const savedKey = localStorage.getItem("KEY_ROOM");
  if (savedKey) {
    const keyInput = document.querySelector(".key_clb");
    if (keyInput) {
      keyInput.value = savedKey;
    }
  }

  const firebaseConfig = {
    apiKey: "AIzaSyCo6Y1YGB4K-YEwSLe8Y7fKFHR1Vcc2saY",
    authDomain: "bigscore-51891.firebaseapp.com",
    projectId: "bigscore-51891",
    storageBucket: "bigscore-51891.appspot.com",
    messagingSenderId: "340847016100",
    appId: "1:340847016100:web:25375cbbeab15759c9ce31",
    measurementId: "G-S5SQ8332D4",
  };

  const app = firebase.initializeApp(firebaseConfig);
  const messaging = firebase.messaging();

  let fcmToken = null;

  // Hàm lấy token FCM
  async function initFCM() {
    try {
      fcmToken = await messaging.getToken({
        vapidKey:
          "BJsN5GUow1l5e4DrnQ4J5jkB4jiSyxG2gpsGhHmf5Use7mZlit0F6esPy3DM8aFyeLDaSB5mlSlux_910BU41yM",
      });
    } catch (err) {}
  }

  initFCM();

  // Bắt sự kiện click tab
  document.addEventListener("click", (e) => {
    if (e.target.classList.contains("tab-btn")) {
      document
        .querySelectorAll(".tab-btn")
        .forEach((btn) => btn.classList.remove("active"));
      e.target.classList.add("active");
      currentTab = e.target.dataset.tab;
      renderRequests();
    }
  });

  if (btnLogin) {
    btnLogin.addEventListener("click", () => {
      connect();
    });
  }

  // Mảng lưu trữ các yêu cầu
  let supportRequests = [];
  let newRequestCount = 0;

  let audioUnlocked = false;

  document.getElementById("enable-sound").addEventListener("click", () => {
    audioUnlocked = true;
    alert("Âm thanh đã sẵn sàng, giờ bạn có thể nhận được thông báo!");
    renderRequests();
  });

  let isPlaying = false;
  let soundQueue = [];
  let queueIndex = 0;

  // bat đầu rung
  function startVibration() {
    if (!vibrationInterval && "vibrate" in navigator) {
      vibrationInterval = setInterval(() => {
        navigator.vibrate([2000]); // rung 2 giây
      }, 3000);
    }
  }

  // dừng rung
  function stopVibration() {
    if (vibrationInterval) {
      clearInterval(vibrationInterval);
      vibrationInterval = null;
    }
    navigator.vibrate(0); // tắt rung ngay lập tức
  }

  function playNotificationSound(message) {
    const text = `Bàn ${message.screen}, ${message.requestStaff}`;
    const item = { id: message.uuid, text };

    // push nếu chưa có
    if (!soundQueue.find((n) => n.id === item.id)) {
      soundQueue.push(item);
    }

    if (!isPlaying) {
      processQueue();
    }
  }

  function processQueue() {
    if (soundQueue.length === 0) {
      isPlaying = false;
      queueIndex = 0;
      stopVibration();
      return;
    }

    isPlaying = true;
    startVibration();

    const current = soundQueue[queueIndex];

    responsiveVoice.speak(current.text, "Vietnamese Female", {
      onend: () => {
        // nếu item hiện tại đã bị xoá thì skip
        if (queueIndex >= soundQueue.length) queueIndex = 0;
        else queueIndex = (queueIndex + 1) % soundQueue.length;

        processQueue();
      },
    });

    startVibration();
  }

  // 👉 Hàm này gọi khi staff "tiếp nhận"
  function removeNotification(id) {
    const index = soundQueue.findIndex((n) => n.id === id);
    if (index !== -1) {
      soundQueue.splice(index, 1);
      // reset queueIndex nếu cần
      if (queueIndex >= soundQueue.length) queueIndex = 0;
    }

    if (soundQueue.length === 0) {
      stopNotificationSound();
      stopVibration();
    }
  }

  function stopNotificationSound() {
    isPlaying = false;
    soundQueue = [];
    queueIndex = 0;
    responsiveVoice.cancel();
  }

  // Hàm thêm yêu cầu vào danh sách
  function addSupportRequest(message) {
    const request = {
      key: key_clb,
      idDevice: message.idDevice,
      requestStaff: message.requestStaff,
      requestScreen: message.screen,
      requestTime: message.requestTime,
      uuid: message.uuid,
      status: message.status,
      isCalling: message.isCalling,
    };

    supportRequests.unshift(request); // Thêm vào đầu mảng
    newRequestCount++;

    // Cập nhật UI
    renderRequests();
    if (request.status === "pending") {
      playNotificationSound(message);
    }

    if (audioUnlocked && request.status === "pending") {
      // Hiển thị thông báo toast
      Toastify({
        text: `Yêu cầu hỗ trợ mới từ bàn ${message.screen}`,
        duration: 3000,
        gravity: "top",
        position: "right",
        style: {
          background: "linear-gradient(to right, #ff8a00, #da1b60)",
        },
      }).showToast();
    }
  }

  // Hàm xác nhận yêu cầu
  function acknowledgeRequest(idDevice, screen, uuid) {
    const request = supportRequests.find((req) => req.uuid === uuid);

    if (request) {
      request.acknowledged = true;
      request.handledBy = clientId || "Bạn";
      request.timeHandle = timeRequest;
      request.status = "ack";

      // Gửi thông báo đến server
      if (ws && ws.readyState === WebSocket.OPEN) {
        ws.send(
          JSON.stringify({
            type: "command",
            action: "staff_ack",
            data: {
              handledBy: clientId,
              key: key_clb,
              idDevice: idDevice,
              requestScreen: screen,
              acknowledged: request.acknowledged,
              timeHandle: timeRequest,
              uuid: request.uuid,
              status: request.status,
            },
          })
        );
      }

      removeNotification(request.uuid);
      // Cập nhật UI
      renderRequests();
    }
  }

  function cancelRequest(idDevice, screen, uuid) {
    const request = supportRequests.find((req) => req.uuid === uuid);

    if (request) {
      request.canceledBy = clientId;
      request.canceledTime = formatDateTime(new Date());
      request.status = "canceled";

      if (ws && ws.readyState === WebSocket.OPEN) {
        ws.send(
          JSON.stringify({
            type: "command",
            action: "staff_cancel",
            data: {
              key: key_clb,
              idDevice: idDevice,
              requestScreen: screen,
              canceledBy: clientId,
              canceledTime: formatDateTime(new Date()),
              uuid: request.uuid,
              status: request.status,
            },
          })
        );
      }
    }
    removeNotification(request.uuid);
    // Re-render UI để thấy ngay trong tab “Đã hủy”
    renderRequests();
  }

  // Hàm render danh sách yêu cầu
  function renderRequests() {
    if (!audioUnlocked) {
      requestListEl.innerHTML =
        '<div class="no-requests">🔇 Vui lòng bấm "Bật âm thanh" để xem danh sách yêu cầu</div>';
      return;
    }
    if (audioUnlocked) {
      document.getElementById("enable-sound").classList.add("hidden");
    }
    const list = supportRequests.filter((r) => r.key === key_clb);

    let filtered = [];
    if (currentTab === "cancel") {
      filtered = list.filter((r) => r.status === "canceled");
    } else if (currentTab === "pending") {
      filtered = list.filter((r) => r.status === "pending" && r.isCalling);
    } else if (currentTab === "ack") {
      // tiếp nhận
      filtered = list.filter((r) => r.status === "ack");
    }

    if (filtered.length === 0) {
      requestListEl.innerHTML =
        '<div class="no-requests">Không có yêu cầu nào</div>';
      return;
    }

    requestListEl.innerHTML = "";
    filtered.forEach((request) => {
      const requestEl = document.createElement("div");
      requestEl.className = `request-card ${request.status}`;

      requestEl.innerHTML = `
      <div class="screen-name">Bàn ${
        request.requestScreen || request.screen
      } </div>
      <div class="time">${request.requestTime || "N/A"}</div>
      <div class="button-container"></div>
    `;

      const buttonContainer = requestEl.querySelector(".button-container");

      if (currentTab === "cancel" && request.status === "canceled") {
        buttonContainer.innerHTML = `
    <div class="canceled-text">
      ❌ Đã hủy bởi <b>${request.canceledBy}</b><br/> ${
          request.canceledTime || "N/A"
        }
    </div>
  `;
      } else if (currentTab === "pending" && request.status === "pending") {
        // Nút Tiếp nhận
        const acceptBtn = document.createElement("button");
        acceptBtn.className = "accept-btn";
        acceptBtn.textContent = "Tiếp nhận";
        acceptBtn.setAttribute("data-request-id", request.idDevice);
        acceptBtn.setAttribute("data-screen-name", request.requestScreen);

        acceptBtn.addEventListener("click", function () {
          timeRequest = new Date().toLocaleString();
          acknowledgeRequest(
            request.idDevice,
            request.requestScreen,
            request.uuid
          );
        });

        // Nút Hủy tiếp nhận
        const cancelBtn = document.createElement("button");
        cancelBtn.className = "cancel-btn";
        cancelBtn.textContent = "Hủy tiếp nhận";
        cancelBtn.addEventListener("click", function () {
          cancelRequest(request.idDevice, request.requestScreen, request.uuid);
        });

        buttonContainer.appendChild(acceptBtn);
        buttonContainer.appendChild(cancelBtn);
      } else if (currentTab === "ack" && request.status === "ack") {
        buttonContainer.innerHTML = `
        <div class="acknowledged-text">
          ✅ Đã tiếp nhận bởi <b>${request.handledBy || "Bạn"}</b><br/>
        
        </div>
      `;
        //   🕒 ${request.timeHandle || "Vừa xong"}
      }

      requestListEl.appendChild(requestEl);
    });
  }

  function connect() {
    const keyCLBInput = document.querySelector(".key_clb").value.trim();
    const keyCLB = keyCLBInput || localStorage.getItem("KEY_ROOM");

    // Lấy clientId từ localStorage, nếu chưa có thì lấy từ input
    clientId = localStorage.getItem("CLIENT_ID");
    if (!clientId) {
      const staffName = document.querySelector(".staff_name").value.trim();
      if (!staffName) {
        alert("Vui lòng nhập tên nhân viên!");
        return;
      }
      clientId = staffName;
      localStorage.setItem("CLIENT_ID", clientId);
    }

    if (!keyCLB) {
      alert("Vui lòng nhập Key CLB phòng!");
      return;
    }

    if (keyCLBInput && keyCLBInput !== localStorage.getItem("KEY_ROOM")) {
      localStorage.setItem("KEY_ROOM", keyCLBInput);
    }

    if (!clientId) {
      alert("Vui lòng nhập tên nhân viên!");
      return;
    }

    ws = new WebSocket(SOCKET_URL);

    ws.onopen = () => {
      // Join room lại
      ws.send(
        JSON.stringify({
          type: "join-room-staff",
          clientId: clientId,
          device: "web",
          key: keyCLB,
          fcmToken: fcmToken,
        })
      );
      ws.send(
        JSON.stringify({
          type: "get-initial-data",
          from: clientId,
          key: keyCLB,
        })
      );
    };

    ws.onmessage = (event) => {
      const message = JSON.parse(event.data);
      clientId = localStorage.getItem("CLIENT_ID", message.clientId);

      switch (message.type) {
        case "room-joined-staff":
          localStorage.setItem("KEY_ROOM", message.key);
          key_clb = localStorage.getItem("KEY_ROOM");
          supportRequests = message.notifies.map((r) => ({
            ...r,
            key: message.key,
          }));

          renderRequests();
          // Hiển thị UI
          loginForm.classList.add("hidden");
          roomUI.classList.remove("hidden");
          roomNameEl.textContent = message.room;

          // Lúc này mới xin dữ liệu
          ws.send(
            JSON.stringify({
              type: "get-initial-data",
              from: clientId,
              key: message.key,
            })
          );
          break;

        case "control":
          switch (message.action) {
            case "call_staff":
              addSupportRequest(message.data);
              renderRequests();
              break;

            case "staff_ack":
              Toastify({
                text: `Nhân viên ${message.data.handledBy} đã tiếp nhận`,
                duration: 3000,
                gravity: "top",
                position: "right",
                style: {
                  background: "linear-gradient(to right, #00b09b, #96c93d)",
                },
              }).showToast();

              supportRequests = supportRequests.map((r) => {
                if (r.uuid === message.data.uuid) {
                  return {
                    ...r,
                    status: "ack",
                    handledBy: message.data.handledBy,
                    timeHandle:
                      message.data.timeHandle || new Date().toLocaleString(),
                  };
                }
                return r;
              });
              removeNotification(message.data.uuid);
              renderRequests();
              break;

            case "staff_cancel":
              Toastify({
                text: `❌ Yêu cầu ${message.data.idDevice} đã bị hủy bởi ${message.data.canceledBy}`,
                duration: 3000,
                gravity: "top",
                position: "right",
                style: {
                  background: "linear-gradient(to right, #ff0000, #ff6600)",
                },
              }).showToast();

              // Cập nhật lại supportRequests: đánh dấu canceledBy và canceledTime
              supportRequests = supportRequests.map((r) => {
                if (r.uuid === message.data.uuid) {
                  return {
                    ...r,
                    status: "canceled",
                    canceledBy: message.data.canceledBy,
                    canceledTime:
                      message.data.canceledTime || new Date().toLocaleString(),
                  };
                }
                return r;
              });
              removeNotification(message.data.uuid);
              renderRequests();
              break;

            case "app_cancel_call_staff":
              supportRequests = supportRequests.map((r) => {
                if (r.uuid === message.data.uuid)
                  return {
                    ...r,
                    isCalling: message.data.isCalling,
                    canceledBy: message.data.canceledBy,
                    canceledTime: message.data.canceledTime,
                    status: message.data.status,
                  };
                return r;
              });
              removeNotification(message.data.uuid);
              renderRequests();
              break;
          }
          break;

        case "error":
          alert("❌ " + message.msg);
          ws.close();
          break;
      }
    };

    ws.onerror = () => {
      alert("Lỗi kết nối WebSocket");
    };
  }

  // Xử lý thoát phòng
  btnExit.addEventListener("click", () => {
    if (ws && ws.readyState === WebSocket.OPEN) {
      ws.send(
        JSON.stringify({
          type: "disconnect",
          clientId: clientId,
          key: key_clb,
        })
      );
      ws.close();
    }

    // Reset UI
    loginForm.classList.remove("hidden");
    roomUI.classList.add("hidden");
    btnLogin.disabled = false;
    // localStorage.removeItem("KEY_ROOM");
    localStorage.removeItem("ROOM_ID");
    localStorage.removeItem("CLIENT_ID");

    // Xóa danh sách yêu cầu
    supportRequests = [];
    newRequestCount = 0;
  });

  // Kết nối khi trang tải (nếu đã có thông tin đăng nhập)
  if (localStorage.getItem("KEY_ROOM") && localStorage.getItem("CLIENT_ID")) {
    connect();
  }
})();
